// DevMode.cpp : Defines the class behaviors for the application.
//

#include "StdAfx.h"
#include "DevMode.h"
#include "DevModeDlg.h"

#ifdef _DEBUG
#define NEW DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDevModeApp

BEGIN_MESSAGE_MAP(CDevModeApp, CWinApp)
	//{{AFX_MSG_MAP(CDevModeApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDevModeApp construction

CDevModeApp::CDevModeApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CDevModeApp object

CDevModeApp theApp;

#define STRLICENSETO			"Amyuni PDF Converter Evaluation"
#define STRACTIVATIONCODE		"07EFCDAB0100010025AFF1801CB9441306C5739F7D452154D8833B9CECBA2ADE79E3762A69FFC354528A5F4A5811BE3204A0A439F5BA"
#define AMYUNI_PRINTER_NAME		"Amyuni PDF Converter"

/////////////////////////////////////////////////////////////////////////////
// CDevModeApp initialization

BOOL CDevModeApp::InitInstance()
{
	AfxEnableControlContainer();

	//Attached to existing PDF Converter
	//Use the same printer name as what you find in the 
	//control panel
	m_converter = ::DriverInit(AMYUNI_PRINTER_NAME);
	if ( NULL == m_converter )
	{
		return false;
	}

	::CDISetDefaultPrinter  ( m_converter );
	::SetFileNameOptions ( m_converter, 3);
	::SetDefaultFileName(m_converter, "c:\\temp\\amyuni.pdf");

	// set the license information
	::EnablePrinter (m_converter,STRLICENSETO, STRACTIVATIONCODE);

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	CDevModeDlg dlg;
	m_pMainWnd = &dlg;
	int nResponse = dlg.DoModal();
	if (nResponse == IDOK)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with OK
	}
	else if (nResponse == IDCANCEL)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with Cancel
	}

	// Since the dialog has been closed, return FALSE so that we exit the
	//  application, rather than start the application's message pump.
	return FALSE;
}
int CDevModeApp::ExitInstance() 
{
	// close printer handle; this will also restore the default printer
	if ( NULL != m_converter )
	{
		::RestoreDefaultPrinter ( m_converter );
		::DriverEnd( m_converter );
	}
	
	return CWinApp::ExitInstance();
}
